<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Kelola Absensi - KSP Bali Surya Mandiri</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Leaflet CSS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
    

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }

        /* Sidebar Styles */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            bottom: 0;
            width: 280px;
            padding: 1.5rem;
            background-color: #212529;
            color: #fff;
            transition: all 0.3s;
            z-index: 1030;
        }

        .sidebar .nav-link {
            color: #adb5bd;
            font-weight: 500;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            transition: background-color 0.2s, color 0.2s;
        }

        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            background-color: #343a40;
            color: #fff;
        }

        .sidebar .nav-link i {
            margin-right: 1rem;
            width: 20px;
            text-align: center;
        }

        .sidebar-brand {
            font-weight: 700;
            font-size: 1.5rem;
            color: #fff;
        }

        /* Main Content Styles */
        .main-content {
            margin-left: 280px;
            transition: margin-left 0.3s;
            padding: 2rem;
        }

        .navbar-custom {
            padding: 1rem 2rem;
            background-color: #fff;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 2px 4px rgba(0, 0, 0, .05);
        }

        /* Card Styles */
        .card-custom {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, .08);
            background-color: #fff;
            overflow: hidden;
        }

        .card-header-custom {
            background: linear-gradient(90deg, #004a7c, #005a9c);
            color: white;
            padding: 1.5rem;
        }

        .welcome-card {
            background: linear-gradient(90deg, #004a7c, #005a9c);
            color: white;
        }

        /* Map Styles */
        #map {
            height: 450px;
            width: 100%;
            border-radius: 0.5rem;
            z-index: 1;
        }

        /* Slider & Controls */
        .form-range::-webkit-slider-thumb {
            background: #005a9c;
        }

        /* Sidebar Responsive Overlay */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1020;
        }

        .sidebar-toggler {
            display: none;
        }

        @media (max-width: 991.98px) {
            .sidebar {
                left: -280px;
            }

            .sidebar.show {
                left: 0;
            }

            .main-content {
                margin-left: 0;
            }

            .sidebar.show~.sidebar-overlay {
                display: block;
            }

            .sidebar-toggler {
                display: block;
            }
        }
    </style>
</head>

<body>

    <!-- Sidebar -->
    <?php echo $__env->make('menu.menuadmin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
        <?php echo $__env->make('menu.topnavbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <main class="mt-4">
            <div class="container-fluid">
                <div class="card card-custom">
                    <!-- Header Card -->
                    <div class="card-header bg-primary text-white p-4 border-0 d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-1 fw-bold">Konfigurasi Radius Absensi</h5>
                            <p class="mb-0 small opacity-75">Tentukan titik pusat lokasi kantor dan jangkauan absen karyawan.</p>
                        </div>
                        <i class="bi bi-geo-alt-fill fs-1 opacity-50"></i>
                    </div>

                    <div class="card-body p-4">
                        <div class="row g-4">
                            <!-- Kolom Kiri: Peta -->
                            <div class="col-lg-8">
                                <div id="map" class="mb-3 shadow-sm"></div>
                                
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="p-3 bg-light rounded-3 border">
                                            <label class="text-uppercase fw-bold text-muted small d-block mb-1">Latitude</label>
                                            <span id="latText" class="font-monospace fw-bold text-dark">-8.670458</span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="p-3 bg-light rounded-3 border">
                                            <label class="text-uppercase fw-bold text-muted small d-block mb-1">Longitude</label>
                                            <span id="lngText" class="font-monospace fw-bold text-dark">115.227125</span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Kolom Kanan: Kontrol -->
                            <div class="col-lg-4">
                                <div class="d-flex flex-column h-100 justify-content-between">
                                    <div>
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <div>
                                                <label class="fw-bold text-dark d-block">Radius Jangkauan</label>
                                                <small class="text-muted">Maksimal jarak absen</small>
                                            </div>
                                            <div class="text-primary fw-bold fs-3">
                                                <span id="radiusValue">100</span><small class="fs-6 ms-1">m</small>
                                            </div>
                                        </div>

                                        <input type="range" class="form-range mb-4" id="radiusSlider" min="10" max="1000" step="10" value="100">

                                        <div class="alert alert-info border-0 rounded-3 small shadow-sm">
                                            <i class="bi bi-info-circle-fill me-2"></i>
                                            <strong>Cara Mengatur:</strong> Geser marker pada peta atau klik di mana saja untuk memindahkan pusat lokasi kantor.
                                        </div>
                                    </div>

                                    <!-- Form Submission -->
                                    <form action="/update-radius" method="POST" id="radiusForm">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="latitude" id="inputLat"
                                            value="<?php echo e($lokasi->latitude ?? -8.670458); ?>">

                                        <input type="hidden" name="longitude" id="inputLng"
                                            value="<?php echo e($lokasi->longitude ?? 115.227125); ?>">

                                        <input type="hidden" name="radius" id="inputRadius"
                                            value="<?php echo e($lokasi->radius ?? 100); ?>">
                                        <button type="submit" class="btn btn-primary btn-lg w-100 rounded-3 shadow-sm py-3 fw-bold">
                                            <i class="bi bi-save2-fill me-2"></i> Simpan Konfigurasi
                                        </button>
                                    </form>



                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Leaflet JS -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script>
    // =========================
    // DATA DARI DATABASE (Blade)
    // =========================
    let lat = <?php echo e($lokasi->latitude ?? -8.670458); ?>;
    let lng = <?php echo e($lokasi->longitude ?? 115.227125); ?>;
    let radius = <?php echo e($lokasi->radius ?? 100); ?>;

    // =========================
    // INIT MAP
    // =========================
    const map = L.map('map').setView([lat, lng], 15);

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap'
    }).addTo(map);

    // =========================
    // MARKER & CIRCLE
    // =========================
    const marker = L.marker([lat, lng], {
        draggable: true
    }).addTo(map);

    const circle = L.circle([lat, lng], {
        color: '#0d6efd',
        fillColor: '#0d6efd',
        fillOpacity: 0.2,
        weight: 2,
        radius: radius
    }).addTo(map);

    // =========================
    // ELEMENT UI
    // =========================
    const slider = document.getElementById('radiusSlider');
    const radiusDisplay = document.getElementById('radiusValue');
    const latDisplay = document.getElementById('latText');
    const lngDisplay = document.getElementById('lngText');

    const inputLat = document.getElementById('inputLat');
    const inputLng = document.getElementById('inputLng');
    const inputRadius = document.getElementById('inputRadius');

    // =========================
    // INIT UI (PENTING)
    // =========================
    function initUI() {
        slider.value = radius;
        radiusDisplay.innerText = radius;

        latDisplay.innerText = lat.toFixed(6);
        lngDisplay.innerText = lng.toFixed(6);

        inputLat.value = lat.toFixed(6);
        inputLng.value = lng.toFixed(6);
        inputRadius.value = radius;
    }

    initUI();

    // =========================
    // UPDATE LOKASI
    // =========================
    function updateLocation(newLat, newLng) {
        lat = newLat;
        lng = newLng;

        marker.setLatLng([lat, lng]);
        circle.setLatLng([lat, lng]);

        latDisplay.innerText = lat.toFixed(6);
        lngDisplay.innerText = lng.toFixed(6);

        inputLat.value = lat.toFixed(6);
        inputLng.value = lng.toFixed(6);
    }

    // =========================
    // UPDATE RADIUS
    // =========================
    function updateRadius(newRadius) {
        radius = newRadius;
        circle.setRadius(radius);

        radiusDisplay.innerText = radius;
        inputRadius.value = radius;
    }

    // =========================
    // EVENT LISTENER
    // =========================

    // Slider radius
    slider.addEventListener('input', function () {
        updateRadius(parseInt(this.value));
    });

    // Drag marker
    marker.on('dragend', function () {
        const pos = marker.getLatLng();
        updateLocation(pos.lat, pos.lng);
    });

    // Klik map
    map.on('click', function (e) {
        updateLocation(e.latlng.lat, e.latlng.lng);
    });

</script>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <?php if(session('success')): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Berhasil',
        text: '<?php echo e(session('success')); ?>',
        timer: 2000,
        showConfirmButton: false
    });
</script>
<?php endif; ?>

</body>

</html><?php /**PATH C:\aplikasi-absensi2\resources\views/lokasikerja.blade.php ENDPATH**/ ?>