<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Absensi Koperasi Simpan Pinjam Bali Surya Mandiri</title>
    <!-- Load Bootstrap 5 CSS via CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" xintegrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <!-- Load Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        /* Custom styles for a modern look */
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8f9fa; /* Light gray background */
        }
        .hero-section {
            background: linear-gradient(135deg, #007bff 0%, #0056b3 100%); /* Blue gradient */
            color: white;
            padding: 100px 0;
            border-radius: 0 0 15px 15px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }
        .feature-card {
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
            transition: transform 0.3s, box-shadow 0.3s;
            height: 100%; /* Ensure cards are same height */
        }
        .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 15px rgba(0, 0, 0, 0.1);
        }
        .icon-circle {
            font-size: 2.5rem;
            color: white;
            background-color: #007bff;
            border-radius: 50%;
            width: 70px;
            height: 70px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 15px;
        }
        .cta-section {
            background-color: #e9ecef;
            padding: 50px 0;
            border-radius: 15px;
            margin-top: 50px;
        }
    </style>
</head>
<body>

    <!-- Navigation Bar (Simple Placeholder) -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm">
        <div class="container">
            <a class="navbar-brand fw-bold" href="#">Koperasi Simpan Pinjam Bali Surya Mandiri </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    
                    <!-- Beranda link, adjust href if needed (e.g., to '/') -->
                    <li class="nav-item">
                        <a class="nav-link active" aria-current="page" href="#">Beranda</a>
                    </li>
                    
                    <!-- Conditional Auth Links (Laravel Blade Syntax) -->
                    <?php if(Route::has('login')): ?>
                        <?php if(auth()->guard()->check()): ?>
                            <!-- Logged In: Show Dashboard Link -->
                            <li class="nav-item">
                                <a href="<?php echo e(url('/dashboard')); ?>" class="nav-link">Dashboard</a>
                            </li>
                            <!-- Optionally, add a Profile link or Logout button here. 
                                Note: Logout typically requires a POST form submission in Laravel. -->
                            <!-- Example Profile link -->
                            <li class="nav-item">
                                <a class="btn btn-outline-light ms-2" href="<?php echo e(url('/profile')); ?>">Profil</a>
                            </li>
                        <?php else: ?>
                            <!-- Not Logged In: Show Login and Register Links -->
                            <li class="nav-item">
                                <a href="<?php echo e(route('login')); ?>" class="btn btn-outline-light ms-2">Log in</a>
                            </li>

                            <?php if(Route::has('register')): ?>
                                <li class="nav-item">
                                    <a href="<?php echo e(route('register')); ?>" class="btn btn-warning ms-2">Register</a>
                                </li>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endif; ?>
                    
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <header class="hero-section text-center">
        <div class="container">
            <h1 class="display-3 fw-bolder mb-3">Selamat Datang di Koperasi Simpan Pinjam Bali Surya Mandiri</h1>
            <p class="lead mb-4">Sistem Absensi Digital yang Modern, Cepat, dan Akurat</p>
            <hr class="my-4 border-light w-25 mx-auto">
            <p>Kelola kehadiran anggota dan karyawan Anda dengan mudah dan efisien.</p>
            
            <!-- Attendance Button (Assuming this is the main action) -->
            <a href="#" class="btn btn-warning btn-lg fw-bold mt-4 shadow-lg">
                <i class="bi bi-clock-fill me-2"></i> Absen Sekarang
            </a>
        </div>
    </header>

    <!-- Main Content: Key Features and Information -->
    <main class="container py-5">
        <section class="text-center mb-5">
            <h2 class="fw-bold mb-4 text-primary">Mengapa Sistem Absensi Ini?</h2>
            <p class="text-muted">Fitur-fitur utama yang dirancang khusus untuk kebutuhan Koperasi Simpan Pinjam Bali Surya Mandiri.</p>
        </section>

        <!-- Feature Cards Grid -->
        <div class="row row-cols-1 row-cols-md-3 g-4">
            <!-- Feature 1: Kecepatan -->
            <div class="col">
                <div class="card feature-card border-0 p-4">
                    <div class="card-body text-center">
                        <div class="icon-circle mx-auto"><i class="bi bi-lightning-charge-fill"></i></div>
                        <h5 class="card-title fw-bold">Absensi Kilat</h5>
                        <p class="card-text text-muted">Proses check-in dan check-out hanya dalam hitungan detik, tanpa antrian.</p>
                    </div>
                </div>
            </div>

            <!-- Feature 2: Akurasi -->
            <div class="col">
                <div class="card feature-card border-0 p-4">
                    <div class="card-body text-center">
                        <div class="icon-circle mx-auto" style="background-color: #28a745;"><i class="bi bi-check2-circle"></i></div>
                        <h5 class="card-title fw-bold">Laporan Akurat</h5>
                        <p class="card-text text-muted">Rekapitulasi kehadiran dengan data yang valid dan minim kesalahan manual.</p>
                    </div>
                </div>
            </div>

            <!-- Feature 3: Aksesibilitas -->
            <div class="col">
                <div class="card feature-card border-0 p-4">
                    <div class="card-body text-center">
                        <div class="icon-circle mx-auto" style="background-color: #ffc107;"><i class="bi bi-phone-fill"></i></div>
                        <h5 class="card-title fw-bold">Akses Mobile</h5>
                        <p class="card-text text-muted">Dapat diakses dari berbagai perangkat, kapan pun dan di mana pun dibutuhkan.</p>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Call to Action / Info Card -->
        <section class="cta-section text-center">
            <h3 class="fw-bold mb-3 text-dark">Siap Mencoba Kemudahan Absensi?</h3>
            <p class="lead mb-4 text-muted">Arahkan ke menu Absen Sekarang atau jelajahi riwayat kehadiran Anda.</p>
            <a href="#" class="btn btn-primary btn-lg fw-bold shadow-sm">
                <i class="bi bi-clipboard-data me-2"></i> Lihat Laporan
            </a>
        </section>
        
    </main>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4 mt-5">
        <div class="container text-center">
            <p class="mb-0">&copy; 2025 Sistem Absensi Koperasi Simpan Pinjam Bali Surya Mandiri. Hak Cipta Dilindungi.</p>
            <small class="text-muted">Didukung oleh Teknologi Digital.</small>
        </div>
    </footer>

    <!-- Load Bootstrap 5 JS via CDN -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" xintegrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>
<?php /**PATH D:\LARAVEL-PROJECTS\Joki\aplikasi-absensi\resources\views/welcome.blade.php ENDPATH**/ ?>