<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard Admin - KSP Bali Surya Mandiri</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Leaflet CSS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY=" crossorigin=""/>
    

    <!-- Custom CSS -->
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f8f9fa; }
        .sidebar { position: fixed; top: 0; left: 0; bottom: 0; width: 280px; padding: 1.5rem; background-color: #212529; color: #fff; transition: all 0.3s; z-index: 1030; }
        .sidebar .nav-link { color: #adb5bd; font-weight: 500; padding: 0.75rem 1rem; border-radius: 0.5rem; transition: background-color 0.2s, color 0.2s; }
        .sidebar .nav-link:hover, .sidebar .nav-link.active { background-color: #343a40; color: #fff; }
        .sidebar .nav-link i { margin-right: 1rem; width: 20px; text-align: center; }
        .sidebar-brand { font-weight: 700; font-size: 1.5rem; color: #fff; }
        .main-content { margin-left: 280px; transition: margin-left 0.3s; padding: 2rem; }
        .navbar-custom { padding: 1rem 2rem; background-color: #fff; border-bottom: 1px solid #dee2e6; box-shadow: 0 2px 4px rgba(0,0,0,.05); }
        .card-custom { border: none; border-radius: 0.75rem; box-shadow: 0 4px 12px rgba(0,0,0,.08); }
        .welcome-card { background: linear-gradient(90deg, #004a7c, #005a9c); color: white; }
        .sidebar-overlay { display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background-color: rgba(0, 0, 0, 0.5); z-index: 1020; }
        .sidebar-toggler { display: none; }
        @media (max-width: 991.98px) {
            .sidebar { left: -280px; }
            .sidebar.show { left: 0; }
            .main-content { margin-left: 0; }
            .sidebar.show ~ .sidebar-overlay { display: block; }
            .sidebar-toggler { display: block; }
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5;
        }
        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .attendance-card {
            width: 100%;
            
            border: none;
            border-radius: 1rem;
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .card-header-custom {
            background: linear-gradient(90deg, #004a7c, #005a9c);
            color: white;
            padding: 1.5rem;
            text-align: center;
        }
        #map {
            height: 250px;
            width: 100%;
        }
        .clock-display {
            font-size: 3rem;
            font-weight: 600;
        }
        .date-display {
            font-size: 1.1rem;
            font-weight: 400;
        }
        .action-buttons .btn {
            padding: 0.75rem;
            font-size: 1.1rem;
            font-weight: 600;
            border-radius: 0.5rem;
        }
        .status-badge {
            font-size: 1rem;
            padding: 0.6rem 1rem;
        }
    </style>
</head>
<body>

<?php echo $__env->make('menu.menuadmin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
<?php echo $__env->make('menu.topnavbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <!-- Page Content -->
        <main class="mt-4">

              

            <div class="main-container">
                <div class="card attendance-card">
                    <div class="card-header-custom">
                        <h4 class="mb-0 fw-bold">Absensi Karyawan</h4>
                        <p class="mb-0">KSP Bali Surya Mandiri</p>
                    </div>
                    <div class="card-body p-4 text-center">
                        
                        <!-- Clock -->
                        <div class="my-3">
                            <div id="clock" class="clock-display">00:00:00</div>
                            <div id="date" class="date-display">Rabu, 15 Oktober 2025</div>
                        </div>

                        <!-- Map -->
                        <div class="card mb-4" id="map-container">
                            <div id="map"></div>
                        </div>
                        <p class="text-muted small"><i class="bi bi-geo-alt-fill"></i> Lokasi Anda saat ini terdeteksi di sekitar area kantor.</p>

                        <!-- Status -->
                        <div id="attendance-status" class="mb-4">
                            <span class="badge rounded-pill bg-secondary-subtle text-secondary-emphasis status-badge">Anda belum melakukan absensi masuk</span>
                        </div>

                        <!-- Buttons -->
                        <div class="d-grid gap-3 action-buttons">
                            <button id="clockInBtn" class="btn btn-success"><i class="bi bi-box-arrow-in-right me-2"></i>Absen Masuk</button>
                            <button id="clockOutBtn" class="btn btn-danger" disabled><i class="bi bi-box-arrow-left me-2"></i>Absen Pulang</button>
                        </div>

                        <!-- Log -->
                        <hr class="my-4">
                        <div class="text-start">
                            <h6 class="fw-bold">Log Absensi Hari Ini:</h6>
                            <ul class="list-group list-group-flush">
                                <li id="logMasuk" class="list-group-item d-flex justify-content-between align-items-center">
                                    Absen Masuk:
                                    <span class="badge bg-secondary">- - : - -</span>
                                </li>
                                <li id="logPulang" class="list-group-item d-flex justify-content-between align-items-center">
                                    Absen Pulang:
                                    <span class="badge bg-secondary">- - : - -</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-footer text-center bg-white border-0 py-3">
                        <p class="mb-0 text-muted small">Powered by KSP Bali Surya Mandiri Tech</p>
                    </div>
                </div>
            </div>


          
        </main>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Leaflet JS -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js" integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo=" crossorigin=""></script>
    <script>
        function toggleSidebar() { document.getElementById('sidebar').classList.toggle('show'); }
    </script>

<script>
        document.addEventListener('DOMContentLoaded', function() {
            const clockElement = document.getElementById('clock');
            const dateElement = document.getElementById('date');
            const clockInBtn = document.getElementById('clockInBtn');
            const clockOutBtn = document.getElementById('clockOutBtn');
            const statusElement = document.getElementById('attendance-status');
            const logMasuk = document.getElementById('logMasuk').querySelector('span');
            const logPulang = document.getElementById('logPulang').querySelector('span');
            
            // Map Initialization
            // Coordinates for Denpasar, Bali
            const officeLocation = [-8.6705, 115.2126]; 
            const map = L.map('map').setView(officeLocation, 15);

            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                maxZoom: 19,
                attribution: '© OpenStreetMap'
            }).addTo(map);

            const marker = L.marker(officeLocation).addTo(map)
                .bindPopup('<b>Lokasi Kantor Pusat</b><br>KSP Bali Surya Mandiri.')
                .openPopup();
            
            // Function to update clock
            function updateClock() {
                const now = new Date();
                const hours = String(now.getHours()).padStart(2, '0');
                const minutes = String(now.getMinutes()).padStart(2, '0');
                const seconds = String(now.getSeconds()).padStart(2, '0');
                clockElement.textContent = `${hours}:${minutes}:${seconds}`;

                const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
                dateElement.textContent = now.toLocaleDateString('id-ID', options);
            }

            setInterval(updateClock, 1000);
            updateClock();
            
            function getCurrentTime() {
                 const now = new Date();
                 const hours = String(now.getHours()).padStart(2, '0');
                 const minutes = String(now.getMinutes()).padStart(2, '0');
                 return `${hours}:${minutes}`;
            }

            // Button actions
            clockInBtn.addEventListener('click', () => {
                const currentTime = getCurrentTime();
                statusElement.innerHTML = `<span class="badge rounded-pill bg-success-subtle text-success-emphasis status-badge">Absen Masuk @ ${currentTime}</span>`;
                logMasuk.textContent = currentTime;
                logMasuk.classList.remove('bg-secondary');
                logMasuk.classList.add('bg-success');

                clockInBtn.disabled = true;
                clockOutBtn.disabled = false;
            });

            clockOutBtn.addEventListener('click', () => {
                const currentTime = getCurrentTime();
                statusElement.innerHTML = `<span class="badge rounded-pill bg-primary-subtle text-primary-emphasis status-badge">Anda sudah absen pulang</span>`;
                 logPulang.textContent = currentTime;
                logPulang.classList.remove('bg-secondary');
                logPulang.classList.add('bg-primary');

                clockOutBtn.disabled = true;
            });
        });
    </script>
</body>
</html>

<?php /**PATH C:\aplikasi-absensi\resources\views/absensisemua.blade.php ENDPATH**/ ?>