<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Laporan Rekapitulasi Absensi Karyawan</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Bootstrap Icons (untuk tombol cetak) -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Google Fonts - Poppins -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom CSS dan Print Styles -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8f9fa;
        }

        .card-custom {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0, 0, 0, .08);
        }

        /* Custom style for report headers */
        .report-header {
            background-color: #212529; /* Dark background like the sidebar in your snippet */
            color: white;
            text-align: center;
        }

        /* Style untuk mode cetak */
        @media print {
            body {
                background-color: #ffffff !important;
                margin: 0;
                padding: 0;
            }
            .no-print {
                display: none !important;
            }
            .card-custom {
                box-shadow: none !important;
                border-radius: 0 !important;
            }
            .table {
                border-collapse: collapse !important;
                width: 100% !important;
            }
            .table th, .table td {
                border: 1px solid #000000 !important;
                padding: 8px !important;
                /* Memastikan warna teks hitam untuk cetak */
                color: #000000 !important; 
            }
            /* Memastikan header laporan berwarna gelap saat dicetak */
            .report-header {
                background-color: #343a40 !important;
                -webkit-print-color-adjust: exact;
                color-adjust: exact;
            }
            /* Menghilangkan background di baris total agar tidak menghabiskan tinta, tapi tetap tebal */
            .total-row {
                background-color: transparent !important;
            }
        }
    </style>
</head>

<body>

    <div class="container py-4">
        <div class="card card-custom">
            
            <!-- Header Laporan -->
            <div class="card-header bg-white border-0 py-3 text-center">
                <h4 class="mb-0 fw-bold">Laporan Rekapitulasi Absensi Karyawan</h4>
                <p class="text-secondary mb-0">KSP Bali Surya Mandiri</p>
                <p class="text-muted small mt-1">Periode: 01 November 2025 - 30 November 2025</p>
            </div>

            <!-- Tombol Cetak -->
            <div class="card-body pt-0 pb-3 d-flex justify-content-end no-print">
                <button onclick="window.print()" class="btn btn-primary shadow-sm">
                    <i class="bi bi-printer-fill me-2"></i>Cetak Laporan (PDF)
                </button>
            </div>

            <!-- Tabel Laporan Rekapitulasi -->
            <div class="card-body pt-0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-bordered align-middle">
                        
                        <!-- Header Tabel -->
                        <thead>
                            <tr>
                                <th scope="col" class="report-header">No.</th>
                                <th scope="col" class="report-header text-start">Nama Pegawai</th>
                                <th scope="col" class="report-header">Hadir Lengkap (Hari)</th>
                                <th scope="col" class="report-header">Absen Tidak Lengkap (Hari)</th>
                                <th scope="col" class="report-header bg-dark">Total Absen (Hari)</th>
                            </tr>
                        </thead>
                        
                        <!-- Body Tabel (Menggunakan Data Dummy) -->
                        <tbody>
                            
                            <tr>
                                <td class="text-center">1.</td>
                                <td><strong class="text-primary">Andi Saputra</strong></td>
                                <td class="text-center text-success fw-bold">20</td>
                                <td class="text-center text-danger">3</td>
                                <td class="text-center fw-bold bg-light text-dark">23</td>
                            </tr>
                            
                            <tr>
                                <td class="text-center">2.</td>
                                <td><strong class="text-primary">Budi Cahyono</strong></td>
                                <td class="text-center text-success fw-bold">18</td>
                                <td class="text-center text-danger">5</td>
                                <td class="text-center fw-bold bg-light text-dark">23</td>
                            </tr>
                            
                            <tr>
                                <td class="text-center">3.</td>
                                <td><strong class="text-primary">Citra Dewi</strong></td>
                                <td class="text-center text-success fw-bold">22</td>
                                <td class="text-center text-danger">1</td>
                                <td class="text-center fw-bold bg-light text-dark">23</td>
                            </tr>

                            <!-- Baris Total Rekapitulasi -->
                            <tr class="table-secondary total-row">
                                <td colspan="2" class="text-end fw-bolder">TOTAL KESELURUHAN:</td>
                                <td class="text-center text-success fw-bolder">60</td>
                                <td class="text-center text-danger fw-bolder">9</td>
                                <td class="text-center text-dark fw-bolder">69</td>
                            </tr>
                            
                        </tbody>
                    </table>
                </div>
            </div>
            
            <!-- Footer Laporan (Tanda Tangan) -->
            <div class="card-footer bg-white border-0 pt-0 pb-4">
                <div class="text-end mt-4 small">
                    <p class="mb-5">Mengetahui,</p>
                    <p class="mb-0 fw-bold">(Nama Manajer/HRD)</p>
                    <p class="text-muted">(Jabatan)</p>
                </div>
            </div>

        </div>
    </div>

    <!-- Bootstrap JS (Diperlukan untuk dropdown/modal jika Anda menambahkannya, tapi tidak penting untuk laporan statis) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Fungsi window.print() akan dipanggil ketika tombol Cetak Laporan diklik.
        // Anda akan memiliki opsi untuk "Save as PDF" di dialog cetak browser.
    </script>
</body>
</html><?php /**PATH C:\aplikasi-absensi2\resources\views/laporan.blade.php ENDPATH**/ ?>