<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Laporan Rekapitulasi Absensi Karyawan</title>
    <!-- CSS Internal untuk Dompdf, fokus pada tata letak cetak yang bersih -->
    <style>
        body {
            font-family: 'Arial', sans-serif;
            margin: 20px;
            padding: 0;
            color: #333;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h1 {
            font-size: 24px;
            margin-bottom: 5px;
        }
        .header h2 {
            font-size: 16px;
            font-weight: normal;
            margin-top: 0;
            margin-bottom: 5px;
        }
        .info-bar {
            text-align: left;
            margin-bottom: 15px;
            font-size: 12px;
        }
        .info-bar p {
            margin: 2px 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
            font-size: 11px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: center;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
            color: #444;
        }
        .text-left {
            text-align: left;
        }
        .total-row td {
            background-color: #e0f7fa; /* Warna latar belakang untuk baris total */
            font-weight: bold;
        }
        .signature-block {
            width: 100%;
            margin-top: 50px;
            font-size: 12px;
        }
        .signature-column {
            width: 50%;
            display: inline-block;
            text-align: center;
        }
        .signature-line {
            margin-top: 60px;
            border-bottom: 1px solid #000;
            display: inline-block;
            width: 80%;
            text-align: center;
        }
        .signature-title {
            margin-top: 5px;
            font-style: italic;
        }

        /* Dompdf umumnya mendukung properti ini, tapi hindari flex/grid kompleks */
        @page {
            margin: 1cm;
        }
    </style>
</head> 
<body>

    <div style="text-align: center; margin-bottom: 20px;">
        <img src="<?php echo e(public_path('images/logo.png')); ?>" style="height: 80px;">
    </div>

    <div class="header">
        <h1>LAPORAN REKAPITULASI ABSENSI KARYAWAN</h1>
        <h2>Koperasi Simpan Pinjam Bali Surya Mandiri</h2>
        <p>Departemen Sumber Daya Manusia</p>
    </div>

    

    <div class="info-bar">
        <p><strong>Periode:</strong> <?php echo e($bulan); ?>-<?php echo e($tahun); ?></p>
        <p><strong>Total Hari Kerja: <?php echo e($totalharikerja); ?></strong>  </p>
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 3%;">No</th>
                <th style="width: 30%;">Nama Karyawan</th>
                <th style="width: 15%;">Lengkap (Hari)</th>
                <th style="width: 15%;">Tidak Lengkap (Hari)</th>
                <th style="width: 12%;">Absen (Hari)</th>
                <th style="width: 15%;">Total Hadir (Hari)</th>
            </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $laporan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($index + 1); ?></td>
            <td class="text-left"><?php echo e($row->name); ?></td>
            <td><?php echo e($row->absen_lengkap); ?></td>
            <td><?php echo e($row->absen_tidak_lengkap); ?></td>
            <td><?php echo e($row->total_alpha); ?></td>
            <td><?php echo e($row->total_hadir); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
        </tbody>
    </table>

    <!-- Blok Tanda Tangan -->
    <div class="signature-block" style="margin-top: 40px;">
    <p style="text-align: right; margin-bottom: 20px;">
        Dicetak, <?php echo e(now()->format('d-m-Y H:i:s')); ?>

    </p>

    <p style="text-align: right; margin-bottom: 80px;">
        Ketua Koperasi
    </p>

    <p style="text-align: right; margin-bottom: 0;">
        <strong><u>I Nyoman Merta Jaya</u></strong>
    </p>
</div>


        <!-- <table style="border: none; margin-bottom: 0;">
            <tr style="border: none;">
                <td style="border: none; text-align: center; vertical-align: top;">
                    Disiapkan oleh:
                    <div style="height: 60px;"></div>
                    <div class="signature-line"></div>
                    <p style="margin-top: 5px;">(Nama Manajer HRD)</p>
                    <p class="signature-title">Manajer HRD</p>
                </td>
                <td style="border: none; text-align: center; vertical-align: top;">
                    Disetujui oleh:
                    <div style="height: 60px;"></div>
                    <div class="signature-line"></div>
                    <p style="margin-top: 5px;">(Nama Direktur)</p>
                    <p class="signature-title">Direktur Utama</p>
                </td>
            </tr>
        </table> -->

    </div>

</body>
</html><?php /**PATH C:\aplikasi-absensi2\resources\views/laporanprint.blade.php ENDPATH**/ ?>