<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Profil Koperasi</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" xintegrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Custom CSS (Sama dengan Dashboard) -->
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f8f9fa;
        }

        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            bottom: 0;
            width: 260px;
            padding: 1.5rem;
            background-color: #212529;
            color: #fff;
            transition: all 0.3s;
            z-index: 1030;
        }

        .sidebar .nav-link {
            color: #adb5bd;
            font-weight: 500;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            transition: background-color 0.2s, color 0.2s;
        }

        .sidebar .nav-link:hover, .sidebar .nav-link.active {
            background-color: #343a40;
            color: #fff;
        }

        .sidebar .nav-link i {
            margin-right: 1rem;
            width: 20px;
            text-align: center;
        }
        
        .sidebar-brand {
            font-weight: 700;
            font-size: 1.5rem;
            color: #fff;
        }

        .sidebar-footer {
            position: absolute;
            bottom: 1rem;
            width: calc(100% - 3rem);
        }

        .main-content {
            margin-left: 260px;
            transition: margin-left 0.3s;
            padding: 2rem;
        }
        
        .navbar-custom {
            padding: 1rem 2rem;
            background-color: #fff;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 2px 4px rgba(0,0,0,.05);
        }
        
        .card-custom {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 4px 12px rgba(0,0,0,.08);
        }

        /* Responsive Styles */
        @media (max-width: 991.98px) {
            .sidebar {
                left: -260px;
            }
            .sidebar.show {
                left: 0;
            }
            .main-content {
                margin-left: 0;
            }
        }
        
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 1020;
        }

        .sidebar.show ~ .sidebar-overlay {
            display: block;
        }
        
        .sidebar-toggler {
            display: none;
        }
        
        @media (max-width: 991.98px) {
            .sidebar-toggler {
                display: block;
            }
        }
    </style>
</head>
<body>

    <!-- Sidebar -->
@include('menu.menuadmin')

    <!-- Main Content -->
    <div class="main-content" id="main-content">
        <!-- Top Navbar -->
@include('menu.topnavbar')
        
        <!-- Page Content -->
        <main class="mt-4">
            <div class="container-fluid">
                <div class="card card-custom">
                    <div class="card-body p-4 p-md-5">

                        <!-- Header Profil -->
                        <div class="text-center mb-5">
                        <img src="{{ asset('images/logo.png') }}" alt="Logo" style="margin-bottom: 20px;" class="h-24 w-auto mx-auto">
                            <h2 class="fw-bold">Koperasi Simpan Pinjam Bali Surya Mandiri</h2>
                            <p class="text-muted">Dari Anggota Oleh Anggota Dan Untuk Anggota</p>
                        </div>

                        <!-- Tentang Kami -->
                        <div class="mb-5">
                            <h4 class="fw-bold border-bottom pb-2 mb-3">Tentang Kami</h4>
                            <p style="text-align: justify;">Koperasi Bali Surya Mandiri khusus bergerak di usaha simpan pinjam yang berdiri pada awal Maret 2010 berkedudukan di Jalan Tirta Empul No. 1 Subak Yeh Aye Bangli. Di awal tahun 2010 kami sudah memulai melakukan penelitian kecil terutama di lingkungan pedesaan di mana tempat kami tinggal. Dari survei yang kita lakukan, banyak menemukan masyarakat yang mempunyai ide gagasan dan keahlian dalam hal tertentu yang jika di kembangkan akan dapat menghasilkan produk yang bisa mendatangkan manfaat bagi kehidupannya sehari hari. Namun di sisi lain mereka perlu pendanaan yang bisa di dapatkan dengan mudah, murah dan cepat yang tentunya hal ini akan sangat susah untuk di dapatkan di Bank besar. Berangkat dari kondisi lingkungan masyarakat seperti itu, maka kami inisiasi untuk memikirkan bagaimana caranya supaya masyarakat bisa berkembang tampak kesulitan untuk mendapatkan modal usaha. Oleh sebab itu maka kami mendirikan Koperasi untuk bisa menampung masyarakat yang membutuhkan modal buat usaha. Di samping itu, kami juga ingin ikut adil di dalam pembangunan perekonomian khususnya di lingkungan desa tempat tinggal kami dan masyarakat umumnya. Sehingga resmilah berdiri Pra Koperasi pada tanggal 1 Maret 2010 dan berbadan hukum pada tanggal 27 Februari 2012. </p>
                        </div>

                        <!-- Visi & Misi -->
                        <div class="row mb-5">
                            <div class="col-md-6 mb-4 mb-md-0">
                                <h4 class="fw-bold border-bottom pb-2 mb-3">Visi</h4>
                                <ol style="text-align: justify;">
                                    <li>Menjadi Koperasi Simpan Pinjam yang sehat dan terpercaya serta memberikan solusi keuangan bagi anggota.</li>
                                    <li>Menjadi sebuah Koperasi yang mengerti akan kebutuhan anggota dan masyarakat serta membantu dan mendukung untuk menjadikan anggota dan masyarakat lebih sejahtera.</li>
                                    <li>Menjalankan kehidupan perkoperasian menuju kemandirian yang kuat melalui kebersamaan dalam pencapaian kesejahteraan anggota pada khususnya dan masyarakat pada umumnya.</li>
                                </ol>
                            </div>
                            <div class="col-md-6">
                                <h4 class="fw-bold border-bottom pb-2 mb-3">Misi</h4>
                                <ul class="list-unstyled">
                                    <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Menyelenggarakan pelayanan yang prima kepada anggota sesuai dengan jati diri Koperasi.</li>
                                    <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Menjalankan usaha simpan pinjam dengan efektif, efisien dan transparan dengan menganut prinsip ke hati hatian.</li>
                                    <li class="mb-2"><i class="bi bi-check-circle-fill text-success me-2"></i>Menjalin kerja sama usaha dengan berbagai pihak untuk meningkatkan manfaat bagi anggota.</li>
                                    <li><i class="bi bi-check-circle-fill text-success me-2"></i>Memajukan pertumbuhan ekonomi dan meningkatkan kesejahteraan bagi anggota melalui pemberian modal usaha serta pendidikan koperasi bagi anggota dan masyarakat.</li>
                                </ul>
                            </div>
                        </div>

                        <!-- Kontak & Alamat -->
                        <div>
                             <h4 class="fw-bold border-bottom pb-2 mb-3">Informasi Kontak</h4>
                             <div class="row">
                                 <div class="col-md-6">
                                     <p><strong><i class="bi bi-geo-alt-fill me-2"></i>Alamat:</strong><br>
                                     Br Penida Kelod, Jehem, Kec. Tembuku, Kabupaten Bangli, Bali 80671</p>
                                 </div>
                                 <div class="col-md-6">
                                     <p><strong><i class="bi bi-telephone-fill me-2"></i>Telepon:</strong><br>
                                     081-236-075-825</p>
                                     <p><strong><i class="bi bi-envelope-fill me-2"></i>Email:</strong><br>
                                     kspbalisuryamandiri12@gmail.com</p>
                                 </div>
                             </div>
                        </div>

                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" xintegrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    
    <script>
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
            document.querySelector('.sidebar-overlay').classList.toggle('show');
        }
    </script>
</body>
</html>
