<form method="POST">
@csrf

<div id="map" style="height:400px"></div>

<input type="hidden" name="latitude" id="latitude" value="{{ $lokasi->latitude }}">
<input type="hidden" name="longitude" id="longitude" value="{{ $lokasi->longitude }}">

<div class="mt-3">
    <label>Radius (meter)</label>
    <input type="number" name="radius" class="form-control" value="{{ $lokasi->radius }}">
</div>

<button class="btn btn-primary mt-3">Simpan Lokasi</button>
</form>

<script>
const map = L.map('map').setView(
    [{{ $lokasi->latitude }}, {{ $lokasi->longitude }}], 17
);

L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png').addTo(map);

const marker = L.marker(
    [{{ $lokasi->latitude }}, {{ $lokasi->longitude }}],
    { draggable: true }
).addTo(map);

marker.on('dragend', function (e) {
    const pos = e.target.getLatLng();
    document.getElementById('latitude').value = pos.lat;
    document.getElementById('longitude').value = pos.lng;
});
</script>
