<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User; 
use Illuminate\Support\Facades\Log; 

class UserController extends Controller
{
    public function create()
    
    {
        return view('users.create');
    }

    public function store(Request $request)
    {
        // 1. TANGKAP DATA DARI FRONTEND
        // Pastikan nama (e.g., 'nama_pegawai', 'posisi_pegawai') 
        // sama dengan yang dikirim JavaScript
        $nama = $request->input('nama_pegawai');
        $posisi = $request->input('posisi_pegawai');
        $email = $request->input('email_pegawai');

        // 2. PROSES DATA (SIMPAN KE DATABASE)
        try {
            // Kita pakai Model 'Pegawai' untuk simpan
            $pegawaiBaru = new User();
            $pegawaiBaru->nama = $nama;
            $pegawaiBaru->posisi = $posisi;
            $pegawaiBaru->email = $email;
            // $pegawaiBaru->password = bcrypt($request->input('password')); // Jika perlu password
            $pegawaiBaru->save(); // <-- Perintah simpan ke tabel

            // 3. BUAT RESPONS SUKSES (JSON)
            // Ini balasan kalau berhasil
            return response()->json([
                'status' => 'success',
                'message' => 'Data pegawai baru berhasil disimpan!',
                'data' => $pegawaiBaru // Kirim balik data yg baru disimpan (opsional)
            ], 201); // 201 = HTTP Status "Created"

        } catch (\Exception $e) {
            // Jika ada error (misal database mati, field salah, dll)
            Log::error('Error simpan pegawai: ' . $e->getMessage());

            // 3. BUAT RESPONS GAGAL (JSON)
            return response()->json([
                'status' => 'error',
                'message' => 'Terjadi kesalahan saat menyimpan data.'
            ], 500); // 500 = HTTP Status "Internal Server Error"
    }
}
}